$(function() {




  var playlist = '.playlist';
  var track    = playlist + ' .sermon-name';


  /**
  * Switch tracks and display metadata.
  * @param {object} track The element with a `data-src` attr pointing to the audio file.
  */
  var switchTrack = function(track) {
    if ($(track).first().length) {
      // Provide visual cue as to which track from the playlist is playing.
      track
        .parents('.sermon-detail')
        .addClass('playing')
        .siblings()
        .removeClass('playing');

      // Load and play the track.
      audio.load($(track).attr('data-src'));
      audio.play();


      // Store metadata in vars.
      var title   = $(track[0]).parent().next().children('.sermon-meta').attr('data-title');
      var speaker = $(track[0]).parent().next().children('.sermon-meta').attr('data-speaker');
      var date    = $(track[0]).parent().next().children('.sermon-meta').attr('data-date');
      var ref     = $(track[0]).parent().next().children('.sermon-meta').attr('data-ref');

      // Load metadata.
      $('.audio--title').text(title);
      $('.audio--speaker').text(speaker);
      $('.audio--date').text(date);
      $('.audio--ref').text(ref);

      // Show metadata.
      $('.player_metadata').slideDown();
    }
  }


  /**
  * Play the next track.
  */
  var nextTrack = function() {
    var next = $('li.playing').next().find('.sermon-name');

    if (!next.length) {
      next = $(track).first();
    }

    next.click();
  }


  /**
  * Play the previous track.
  */
  var prevTrack = function() {
    var prev = $('li.playing').prev().find('.sermon-name');

    if (!prev.length) {
      prev = $(track).last();
    }

    prev.click();
  }


  /**
   * Turn up the volume.
   */
  var volumeUp = function() {
    var volume = audio['element']['volume'];

    if (volume <= 0.9) {
      audio.setVolume(volume + 0.1);
    }
  }


  /**
   * Turn down the volume.
   */
  var volumeDown = function() {
    var volume = audio['element']['volume'];

    if (volume >= 0.1) {
      audio.setVolume(volume - 0.1);
    }
  }





  var options = {
    createPlayer: {
      markup: '\
        <div class="scrubber">\
          <div class="progress"></div>\
          <div class="loaded"></div>\
        </div>\
        <div class="prev-next">\
          <p class="prev icon">⏮</p>\
        </div>\
        <div class="play-pause">\
          <p class="play icon">▶</p>\
          <p class="pause icon">‖</p>\
          <p class="loading icon">▶</p>\
          <p class="error icon">⚠</p>\
        </div>\
        <div class="prev-next">\
          <p class="next icon">⏭</p>\
        </div>\
        <div class="volume">\
          <p class="label">VOL</p>\
          <p class="volume_down icon">➖</p>\
          <p class="volume_up icon">➕</p>\
        </div>\
        <div class="time">\
          <span class="played">00:00</span>/<strong class="duration">00:00</strong>\
        </div>\
        <div class="error-message"></div>',
      playPauseClass:    'play-pause',
      scrubberClass:     'scrubber',
      progressClass:     'progress',
      loaderClass:       'loaded',
      timeClass:         'time',
      durationClass:     'duration',
      playedClass:       'played',
      errorMessageClass: 'error-message',
      playingClass:      'playing',
      loadingClass:      'loading',
      errorClass:        'error'
    },
    css: '',
    trackEnded: function() {
      var next = $(track + '.playing').next();

      if (!next.length) {
        next = $(track).first();
      }

      switchTrack(next);
    }
  }

  // Create the player.
  var a     = audiojs.create($('#audio_player'), options);
  var audio = a[0];



  // Play first track if loading icon (greyed out play icon) is clicked.
  $('.loading').click(function() {
    // We can't just automatically play because audio.js does something to keep us from doing so.
    // Instead wait a bit (100ms) before attempting to play.
    setTimeout(function(){
      switchTrack($(track).first());
    }, 100);
  });

  // Load in a track on click
  $(track).click(function(e) {
    e.preventDefault();
    switchTrack($(this));
  });



  // Load previous track on previous button click.
  $('.prev').click(function() {
    prevTrack();
  });

  // Load next track on next button click.
  $('.next').click(function() {
    nextTrack();
  });

  // Turn up the volume on volume up button click.
  $('.volume_up').click(function() {
    volumeUp();
  });

  // Turn down the volume on volume down button click.
  $('.volume_down').click(function() {
    volumeDown();
  });





  /**
   * Remove books without sermons from the nav list.
   */
  var $booksList = document.querySelector('.accordion-list--books');
  var booksUsed  = document
                    .getElementById('books_with_sermons')
                    .getAttribute('data-books');

  for (var i in $booksList.childNodes) {
    if ($booksList.childNodes[i].className == 'sermon-nav-link') {
      if (
        booksUsed.indexOf($booksList.childNodes[i].getAttribute('id')) === -1
      ) {
        $booksList.childNodes[i].remove();
      }
    }
  }

  /**  Grab url directly */
  var getUrlParameter = function getUrlParameter(sParam) {
    var sPageURL = decodeURIComponent(window.location.search.substring(1)),
    sURLVariables = sPageURL.split('&'),
    sParameterName,
    i;

    for (i = 0; i < sURLVariables.length; i++) {
      sParameterName = sURLVariables[i].split('=');

      if (sParameterName[0] === sParam) {
        return sParameterName[1] === undefined ? true : sParameterName[1];
      }
    }
  };

  if(getUrlParameter('autoplay')!=undefined){
    switchTrack($(track).first());
  }

});
