  <?php
class Plugin_slug_machine extends Plugin
{

  var $meta = array(
    'name'       => 'Slug Machine',
    'version'    => '1.0',
    'author'     => 'Curtis Blackwell',
    'author_url' => 'http://curtisblackwell.com'
  );

  /**
   * Makes slugs out of content within its tag pair. Works with plugins, unlike variable modifiers.
   * @return string sluggified version of input
   */
  public function maker() {
    $arr    = array($this->content);
    $return = Slug::make(Parse::template($this->content, $arr));

    if ($this->fetch('lower') == true) {
      $return = strtolower($return);
    }

    return $return;
  }


  /**
   * Finds and returns a slug/segment.
   * @return string nth slug
   */
  public function extractor() {
    $delimiter  = $this->fetch('delimiter',  '/',  NULL, NULL, FALSE);
    $string     = $this->fetch('string'                             );
    $n          = $this->fetch('n',          1                      ) - 1;
    $remove_ext = $this->fetch('remove_ext', FALSE, FALSE, TRUE     );

    $string = Path::trimSlashes($string);
    $slugs  = explode($delimiter, $string);

    if ($remove_ext) {
      $slugs[$n] = substr($slugs[$n], 0, strpos($slugs[$n], '.'));
    }

    return $slugs[$n];
  }

}
