$(document).ready(function() {
  var petrie = {
    container: $('.petrie')
  };
  // Configured fieldsets are stored as a pipe-separated list in a data-attribute.
  // Store that list in a var and create a regex with it.
  petrie.fieldsets      = petrie.container.children('[data-fieldsets]').attr('data-fieldsets');
  petrie.fieldsetsRegex = new RegExp(petrie.fieldsets);
  petrie.fieldset       = null;


  // If this page's fieldset is one of those Petrie is configured to work with,
  // store that info in a variable in order to remove all other Petrie info.
  if ($('[name="page[fieldset]"]').length > 0 &&
      $('[name="page[fieldset]"]').val().match(petrie.fieldsetsRegex))
  {
    fieldset = $('[name="page[fieldset]"]').val().match(petrie.fieldsetsRegex)[0];

    petrie.fieldset = $('[name="page[petrie][' + fieldset + ']"]');
  }

  // Remove all irrelevant Petrie info.
  $('[name^="page[petrie]"]').not(petrie.fieldset).remove();
});
