<?php
class Hooks_petrie extends Hooks
{
    public function control_panel__add_to_foot()
    {
        if (URL::getCurrent() == '/publish') {
            $html  = $this->js->link('petrie.js');

            // Store necessary info in the DOM so that petrie.js can do its job.
            // _config/add-ons/petrie/petrie.yaml should look something like this;
            //
            // fieldsets:
            //   blog_root:
            //     yaml: blog
            //   events_root:
            //     yaml:
            //       type: date
            //       _fieldset: events
            $config    = $this->getConfig();
            $fieldsets = $config['fieldsets'];
            $fieldsets_list = implode('|', array_keys($fieldsets));

            $html .= '<div class="petrie">';
            $html .=   '<div data-fieldsets="' . $fieldsets_list . '"></div>';
            $html .= '</div>';


            return $html;
        }
    }





    public function control_panel__add_to_publish_form()
    {
        $config    = $this->getConfig();
        $fieldsets = $config['fieldsets'];
        $html = '';
        foreach ($fieldsets as $fieldset => $data) {
            if (is_array($data['yaml'])) {
                $yaml = json_encode($data['yaml']);
            } else {
                $yaml = $data['yaml'];
            }

            $html .= "<input type='hidden' name='page[petrie][$fieldset]' value='$yaml'>";


        }

        return $html;
    }





    public function control_panel__publish($publish_data)
    {
        // d($publish_data);
        // d($_POST);
        if (array_key_exists('petrie', $_POST['page'])) {
            $petrie_data = $_POST['page']['petrie'];
            $yaml        = key($petrie_data);
            $target      = Path::trimSlashes(
                $this->core->pathMinusLastNSegments($publish_data['file'], 2) . '/fields.yaml'
            );

            if (!File::exists($target)) {
                // If $yaml is JSON, decode it into an array, and dump it into a file.
                if (strpos($petrie_data[$yaml], ':') !== false) {
                    $yaml = json_decode($petrie_data[$yaml], true);

                    File::put($target, Yaml::dump($yaml));

                // If $yaml is a path to a YAML file, copy the file.
                } else {
                    $existing_fields_yaml_path = $petrie_data[$yaml];

                    $original = Path::trimSlashes(
                        Path::assemble(
                            Config::getContentRoot(),
                            Path::resolve($existing_fields_yaml_path),
                            'fields.yaml'
                        )
                    );

                    File::copy($original, $target);
                }
            }
        }


        // Give the data back to Statamic.
        return $publish_data;
    }
}
