<?php
class Core_petrie extends Core
{
   /**
    * Returns every segment up to and including the nth.
    * @param  string $path The path to grab segments from.
    * @param  num    $n    The number of segments to grab.
    * @return string       Segments up to n
    */
    public function pathMinusLastNSegments($path, $n)
    {
        $path               = Path::trimSlashes($path);
        $slugs              = explode('/', $path);
        // Total number of slugs
        $slugs_total        = count($slugs);
        // Index of the final slug to return
        $return_index_final = $slugs_total - $n;

        $return = '';
        for ($i = 0; $i <= $return_index_final; $i++) {
            $return .= '/' . $slugs[$i];
        }

        return $return;
    }
}
